/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement;

import com.github.bartimaeusnek.bartworks.util.BW_Tooltip_Reference;
import com.github.bartimaeusnek.crossmod.tectech.helper.CoilAdder;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement.TT_Abstract_GT_Replacement;
import com.github.bartimaeusnek.crossmod.tectech.tileentites.multi.GT_Replacement.TT_Abstract_GT_Replacement_Coils;
import com.github.technus.tectech.mechanics.structure.IStructureDefinition;
import com.github.technus.tectech.mechanics.structure.IStructureElement;
import com.github.technus.tectech.mechanics.structure.StructureDefinition;
import com.github.technus.tectech.mechanics.structure.StructureUtility;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.GT_MetaTileEntity_MultiblockBase_EM;
import com.github.technus.tectech.thing.metaTileEntity.multi.base.render.TT_RenderedExtendedFacingTexture;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class TT_MultiSmelter
extends TT_Abstract_GT_Replacement_Coils {
    private int mLevel;
    private int mCostDiscount;
    private static final byte TEXTURE_INDEX = 11;
    private static final IStructureDefinition<TT_MultiSmelter> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"AAA", "AMA", "AAA"}, {"CCC", "C-C", "CCC"}, {"A~A", "AAA", "AAA"}})).addElement(Character.valueOf('C'), CoilAdder.getINSTANCE()).addElement(Character.valueOf('M'), (IStructureElement)StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiblockBase_EM::addClassicMufflerToMachineList, (int)11, (int)1)).addElement(Character.valueOf('A'), StructureUtility.ofHatchAdderOptional(TT_Abstract_GT_Replacement::addEBFInputsBottom, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11, (Block)GregTech_API.sBlockCasings1, (int)11)).build();
    private static final String[] sfStructureDescription = new String[]{"0 - Air", "1 - Muffler", "Required: Output Bus, Input Bus, Energy Hatch, Maintenance Hatch"};
    private static final int pollutionPerTick = 20;
    private static final String[] desc = new String[]{"Furnace", "Controller Block for the Multi Smelter", "Smelts up to 8-128 items at once", "Items smelted increases with coil tier", "Creates up to: 400 Pollution per Second", BW_Tooltip_Reference.ADV_STR_CHECK, BW_Tooltip_Reference.TT_BLUEPRINT};

    public TT_MultiSmelter(Object unused, Object unused2) {
        super(1003, "multimachine.multifurnace", "Multi Smelter");
    }

    private TT_MultiSmelter(String aName) {
        super(aName);
    }

    public String[] getStructureDescription(ItemStack itemStack) {
        return sfStructureDescription;
    }

    public IStructureDefinition<TT_MultiSmelter> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    protected boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        this.mLevel = 0;
        this.mCostDiscount = 1;
        this.setCoilHeat(HeatingCoilLevel.None);
        boolean ret = this.structureCheck_EM("main", 1, 2, 0) && this.getCoilHeat() != HeatingCoilLevel.None;
        this.mMufflerHatches.forEach(x -> x.setInValidFacings(new ForgeDirection[]{this.getExtendedFacing().getRelativeUpInWorld().getOpposite()}));
        if (this.mMufflerHatches.stream().map(MetaTileEntity::getBaseMetaTileEntity).mapToInt(ITurnable::getFrontFacing).noneMatch(x -> x == this.getExtendedFacing().getRelativeUpInWorld().ordinal())) {
            return false;
        }
        this.mLevel = this.getCoilHeat().getLevel();
        this.mCostDiscount = this.getCoilHeat().getCostDiscount();
        this.setInputFilters();
        return ret;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sFurnaceRecipes;
    }

    public void construct(ItemStack itemStack, boolean b) {
        this.structureBuild_EM("main", 1, 2, 0, b, itemStack);
    }

    public String[] getDescription() {
        return desc;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11], new TT_RenderedExtendedFacingTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER))};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][11]};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new TT_MultiSmelter(this.mName);
    }

    public boolean checkRecipe_EM(ItemStack aStack) {
        ArrayList tInputList = this.getStoredInputs();
        if (tInputList.isEmpty()) {
            return false;
        }
        int mVolatage = GT_Utility.safeInt((long)this.getMaxInputVoltage());
        int tMaxParrallel = 8 * this.mLevel;
        int tCurrenParrallel = 0;
        ItemStack tSmeltStack = (ItemStack)tInputList.get(0);
        ItemStack tOutputStack = GT_ModHandler.getSmeltingOutput((ItemStack)tSmeltStack, (boolean)false, null);
        if (tOutputStack == null) {
            return false;
        }
        for (ItemStack item : tInputList) {
            if (!tSmeltStack.func_77969_a(item)) continue;
            if (item.field_77994_a < tMaxParrallel - tCurrenParrallel) {
                tCurrenParrallel += item.field_77994_a;
                item.field_77994_a = 0;
                continue;
            }
            item.field_77994_a = tCurrenParrallel + item.field_77994_a - tMaxParrallel;
            tCurrenParrallel = tMaxParrallel;
            break;
        }
        this.mOutputItems = new ItemStack[(tCurrenParrallel *= tOutputStack.field_77994_a) / 64 + 1];
        for (int i = 0; i < this.mOutputItems.length; ++i) {
            int size;
            ItemStack tNewStack = tOutputStack.func_77946_l();
            tNewStack.field_77994_a = size = Math.min(tCurrenParrallel, 64);
            tCurrenParrallel -= size;
            this.mOutputItems[i] = tNewStack;
        }
        if (this.mOutputItems.length > 0) {
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            this.calculateOverclockedNessMulti(4, 512, 1, mVolatage);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            this.mEUt = GT_Utility.safeInt((long)((long)this.mEUt * (long)this.mLevel / (long)this.mCostDiscount), (int)1);
            if (this.mEUt == 0x7FFFFFFE) {
                return false;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
        }
        this.updateSlots();
        return true;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 20;
    }

    public String[] getInfoData() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!TT_MultiSmelter.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            mPollutionReduction = Math.max(tHatch.calculatePollutionReduction(100), mPollutionReduction);
        }
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!TT_MultiSmelter.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + this.mProgresstime / 20 + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + this.mMaxProgresstime / 20 + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + storedEnergy + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + maxEnergy + EnumChatFormatting.RESET + " EU", StatCollector.func_74838_a((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + -this.mEUt + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + this.getMaxInputVoltage() + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier((long)this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"GT5U.MS.multismelting") + ": " + EnumChatFormatting.GREEN + this.mLevel * 8 + EnumChatFormatting.RESET + " Discount: (EU/t) / " + EnumChatFormatting.GREEN + this.mCostDiscount + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.multiblock.pollution") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %"};
    }
}

